<?php
// Strict error reporting in development, disable in production
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include helpers
require_once __DIR__ . "/../connection.php";
require_once __DIR__ . "/../auth.php";

// Set CORS headers
setCorsHeaders();


// Only allow GET requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405); // Method Not Allowed
    exit(json_encode(['success' => false, 'message' => 'Method Not Allowed']));
}

	//param
	$jsonobj = array();
	$json_str = file_get_contents('php://input');
	$jsonobj = json_decode($json_str, true);
			
	$kodepaket    = $jsonobj["kodepaket"];
	
	//validate
    if ($kodepaket == "1000")
    {
        $namapaket = "Basic 30 Hari";
        $price = 49000;
    }
    else
    {
        if ($kodepaket == "1002")
        {
            $namapaket = "Basic 90 Hari";
            $price = 99000;
        }
        else
        {
            $namapaket = "Basic 180 Hari";
            $price = 149000;
        }
    }
       
    // Format the response
    $response = [
        "success" => true,
        "data" => [
            "kodepaket" => $kodepaket,
            "namapaket" => $namapaket,
            "price" => $price,
            "imageurl" => "https://api.ezlink.dev/matrixweb/assets/paketnex/diamond.jpg"
        ]
    ];
    
    sendJsonResponse($response, 200);
?>