<?php

// Strict error reporting in development, disable in production
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include helpers
require_once __DIR__ . "/../connection.php";
require_once __DIR__ . "/../auth.php";

// Set CORS headers
setCorsHeaders();

// Only allow GET requests
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405); // Method Not Allowed
    exit(json_encode(['success' => false, 'message' => 'Method Not Allowed']));
}

try {
    // Get PDO connection
    $pdo = connectDB();
    
    // Validate API key
    validateApiKey();
    
    // Get golongan data
    $golonganQuery = "SELECT * FROM mst_golongan ORDER BY golongan";
    $golonganStmt = $pdo->prepare($golonganQuery);
    $golonganStmt->execute();
    $golongans = $golonganStmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Get nexcategory data
    $nexCategoryQuery = "SELECT * FROM mst_nexcategory ORDER BY category";
    $nexCategoryStmt = $pdo->prepare($nexCategoryQuery);
    $nexCategoryStmt->execute();
    $nexCategories = $nexCategoryStmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Get logo data
    $logoQuery = "SELECT * FROM mst_logo LIMIT 1";
    $logoStmt = $pdo->prepare($logoQuery);
    $logoStmt->execute();
    $logoData = $logoStmt->fetch(PDO::FETCH_ASSOC);
    
    // Get base URL from config for logo images
    $baseUrl = getenv('BASE_URL') ?: 'https://api.ezlink.dev/matrixweb/assets';
    $baseUrl = rtrim($baseUrl, '/') . '/logo/';
    
    // Format logo URLs if data exists
    $logoInfo = null;
    if ($logoData) {
        $logoInfo = [
            'id' => $logoData['id'],
            'logo' => !empty($logoData['logo']) ? $baseUrl . $logoData['logo'] : null,
            'logobottom' => !empty($logoData['logobottom']) ? $baseUrl . $logoData['logobottom'] : null
        ];
    }
    
    // Format the response
    $response = [
        "success" => true,
        "data" => [
            "golonganproduct" => $golongans,
            "paketnex" => $nexCategories,
            "logo" => $logoInfo
        ]
    ];
    
    // Send successful response
    sendJsonResponse($response, 200);
    
} catch (Exception $e) {
    $errorCode = $e->getCode();
    $errorCode = is_int($errorCode) ? $errorCode : 500;
    
    // Prepare error response
    $response = [
        "success" => false,
        "message" => $e->getMessage(),
        "data" => null
    ];
    
    // Hide internal error details from users
    if ($errorCode >= 500) {
        error_log("Top Menu API error: " . $e->getMessage() . "\n" . $e->getTraceAsString());
        $response["message"] = "An internal error occurred";
    }
    
    // Send error response with appropriate status code
    $statusCode = ($errorCode >= 400 && $errorCode < 600) ? $errorCode : 500;
    sendJsonResponse($response, $statusCode);
}
?>