<?php

// Strict error reporting in development, disable in production
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include helpers
require_once __DIR__ . "/../connection.php";
require_once __DIR__ . "/../auth.php";

// Set CORS headers
setCorsHeaders();

// Only allow GET requests
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405); // Method Not Allowed
    exit(json_encode(['success' => false, 'message' => 'Method Not Allowed']));
}



try {
    // Get PDO connection
    $pdo = connectDB();
    
    // Validate API key
    validateApiKey();
    
   
    // Get about ID and sanitize
    $aboutId = "ourteam";
    
    // Query about data
    $aboutStmt = $pdo->prepare("
        SELECT id, content, banner
        FROM mst_about
        WHERE id = :id 
    ");
    $aboutStmt->bindParam(':id', $aboutId, PDO::PARAM_STR);
    $aboutStmt->execute();
    
    // Check if about record exists
    if ($aboutStmt->rowCount() === 0) {
        throw new Exception("Our Team content not found", 404);
    }
    
    $aboutData = $aboutStmt->fetch(PDO::FETCH_ASSOC);
    
    // If banner exists, prepend the base URL
    if (!empty($aboutData['banner'])) {
        // Get base URL from environment or configuration
        $baseUrl = getenv('BASE_URL') ?: 'https://api.ezlink.dev/matrixweb/assets';
        
        // The banner field already contains the relative path (/web/filename.jpg)
        // Just add it to the base URL to create the full URL
        $aboutData['banner_url'] = $baseUrl . $aboutData['banner'];
    } else {
        $aboutData['banner_url'] = null;
    }
    
    // Format the response
    $response = [
        "success" => true,
        "message" => "About content retrieved successfully",
        "data" => $aboutData
    ];
    
    // Send successful response
    sendJsonResponse($response, 200);
    
} catch (Exception $e) {
    $errorCode = $e->getCode();
    $errorCode = is_int($errorCode) ? $errorCode : 500;
    
    // Prepare error response
    $response = [
        "success" => false,
        "message" => $e->getMessage(),
        "data" => null
    ];
    
    // Hide internal error details from users
    if ($errorCode >= 500) {
        error_log("View About API error: " . $e->getMessage());
        $response["message"] = "An internal error occurred";
    }
    
    // Send error response with appropriate status code
    $statusCode = ($errorCode >= 400 && $errorCode < 600) ? $errorCode : 500;
    sendJsonResponse($response, $statusCode);
}
?>