<?php

// Strict error reporting in development, disable in production
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include helpers
require_once __DIR__ . "/../connection.php";
require_once __DIR__ . "/../auth.php";

// Set CORS headers
setCorsHeaders();

// Only allow GET requests
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405); // Method Not Allowed
    exit(json_encode(['success' => false, 'message' => 'Method Not Allowed']));
}

try {
    // Get PDO connection
    $pdo = connectDB();
    
    // Validate API key
    validateApiKey();
    
    $kecamatanid = intval($_GET['kecamatanid']);

        // Build the query with join to get golongan name
    $query = "
        SELECT id, kelurahan
        FROM mst_kelurahan where kecamatanid = :kecamatanid order by kelurahan
    ";
  
        $stmt = $pdo->prepare($query);
        $stmt->bindParam(':kecamatanid', $kecamatanid, PDO::PARAM_INT);
        $stmt->execute();
        $kelurahan = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        // Format the response without pagination
        $response = [
            "success" => true,
            "data" => $kelurahan
        ];
     
    // Send successful response
    sendJsonResponse($response, 200);
    
} catch (Exception $e) {
    $errorCode = $e->getCode();
    $errorCode = is_int($errorCode) ? $errorCode : 500;
    
    // Prepare error response
    $response = [
        "success" => false,
        "message" => $e->getMessage(),
        "data" => null
    ];
    
    // Hide internal error details from users
    if ($errorCode >= 500) {
        error_log("List Categories API error: " . $e->getMessage() . "\n" . $e->getTraceAsString());
        $response["message"] = "An internal error occurred";
    }
    
    // Send error response with appropriate status code
    $statusCode = ($errorCode >= 400 && $errorCode < 600) ? $errorCode : 500;
    sendJsonResponse($response, $statusCode);
}
?>