<?php

// Strict error reporting in development, disable in production
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include helpers
require_once __DIR__ . "/../connection.php";
require_once __DIR__ . "/../auth.php";

// Set CORS headers
setCorsHeaders();

// Only allow GET requests
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405); // Method Not Allowed
    exit(json_encode(['success' => false, 'message' => 'Method Not Allowed']));
}



try {
    // Get PDO connection
    $pdo = connectDB();
    
    // Validate API key
    validateApiKey();
    
   
    // Fetch contact data (id is always 1)
    $contactId = 1;
    
    // Query contact data
    $contactStmt = $pdo->prepare("
        SELECT id, address, phone, email 
        FROM mst_contact 
        WHERE id = :id 
    ");
    $contactStmt->bindParam(':id', $contactId, PDO::PARAM_INT);
    $contactStmt->execute();
    
    // Check if contact record exists
    if ($contactStmt->rowCount() === 0) {
        // If no contact record exists, create a default one
        $insertStmt = $pdo->prepare("
            INSERT INTO mst_contact (id, address, phone, email) 
            VALUES (:id, '', '', '')
        ");
        $insertStmt->bindParam(':id', $contactId, PDO::PARAM_INT);
        $insertStmt->execute();
        
        // Get the newly created record
        $contactStmt->execute();
    }
    
    $contactData = $contactStmt->fetch(PDO::FETCH_ASSOC);
    
    // Format the response
    $response = [
        "success" => true,
        "message" => "Contact information retrieved successfully",
        "data" => $contactData
    ];
    
    // Send successful response
    sendJsonResponse($response, 200);
    
} catch (Exception $e) {
    $errorCode = $e->getCode();
    $errorCode = is_int($errorCode) ? $errorCode : 500;
    
    // Prepare error response
    $response = [
        "success" => false,
        "message" => $e->getMessage(),
        "data" => null
    ];
    
    // Hide internal error details from users
    if ($errorCode >= 500) {
        error_log("View Contact API error: " . $e->getMessage());
        $response["message"] = "An internal error occurred";
    }
    
    // Send error response with appropriate status code
    $statusCode = ($errorCode >= 400 && $errorCode < 600) ? $errorCode : 500;
    sendJsonResponse($response, $statusCode);
}
?>