<?php

function connectDB() {
    // Load credentials from environment variables securely
    $servername = $_ENV['DB_HOST'] ?? 'localhost';
    $username = $_ENV['DB_USER'] ?? null;
    $password = $_ENV['DB_PASSWORD'] ?? null;
    $dbname = $_ENV['DB_NAME'] ?? null;
    $port = $_ENV['DB_PORT'] ?? 3306;

    // Validate required environment variables
    if (!$username || !$password || !$dbname) {
        throw new Exception("Database credentials are missing");
    }

    try {
        // Enable error handling with exceptions
        $dsn = "mysql:host=$servername;port=$port;dbname=$dbname;charset=utf8mb4";
        $options = [
            PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,  // Enable exceptions on errors
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,        // Fetch data as associative array
            PDO::ATTR_EMULATE_PREPARES   => true,                   // Prevent SQL injection
        ];

        // Create PDO instance
        $pdo = new PDO($dsn, $username, $password, $options);
        
        return $pdo;
    } catch (PDOException $e) {
        // Secure error logging
        error_log("Database connection error: " . $e->getMessage());


        // Return a generic error to prevent information disclosure
        throw new Exception("Database service unavailable");
    }
}	

 
?>